<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Vehicles extends CI_Model {
		
		public function __construct(){
			
			$this->table="equipments";
			$this->datetime=date("Y-m-d H:i:s");
		    $this->id=$this->session->userdata('id');
		   
		    $this->first_name=$this->session->userdata('first_name');
		   
		   
		}

		public function creates()
		{
			
			$this->db->trans_begin();
			if($this->db->insert( $this->table, [
				'equipmentName' => $this->input->post("equipmentName"),
				'DateCreated' => $this->datetime,
				'DateModified' => $this->datetime,
                'CreatedBy' => $this->id,
                'ModifiedBy' => $this->id,
                	
			] )){
				  $id = $this->db->insert_id();
                 

				  $this->db->insert('audit', [
						'Description' =>  $this->first_name ." added Equipment Name -".  $this->input->post("equipmentName"),
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
				] );

				       
			    if ($this->db->trans_status() === FALSE)
	 			{
	       				 $this->db->trans_rollback();
	       				 return false;
					}
					else
					{
	      				  $this->db->trans_commit();
	      				     return true;
				}
				}else{
					return false;
				}

				
				
				
			
		}

		
		public function lists()
		{
			$rows = [];
			$this->db->select('t.*,u.FirstName,,s.Title as status' )
					->from($this->table .' t')    
					->join('users u', 't.CreatedBy=u.UserId')
					 ->join('statuses s', 't.Status=s.StatusId') 
					->order_by('t.id','DESC');
			//$this->db->where( array('t.Status'=>1),'AND');
			$query = $this->db->get();
			if($query->result()){
				$rows = $query->result();	
				$query->free_result();	
			}
			return( $rows );
		}
		
		public function details($id){
			$row = array();		
			$this->db->select('*');
			$this->db->from( $this->table);	
            $this->db->where('id',$id);
            $query = $this->db->get();
			if($query->result()){
				$row = $query->row();	
				$query->free_result();	
			}
			
			return( $row );
		}

		
		
		
		public function deletee($id)
		{
			$data = array(
				'DateModified' => $this->datetime,
				'Status' => 0 ,	
				'ModifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." deactivated Equipment Name ",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		public function activateds($id)
		{
			$data = array(
				'DateModified' => $this->datetime,
				'Status' => 1 ,	
				'ModifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." activated Equipment Name",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		
		public function editst($id)
		{
			 		
			 
			 $data = array(
			 	'equipmentName' => $this->input->post("equipmentName"),
				'DateModified' => $this->datetime,
                'ModifiedBy' => $this->id,
				
			  );

			  $this->db->where('id',$id);
			  
			  if($this->db->update($this->table,  $data)){
			  		$this->db->insert('audit', [
			  			'Description' =>  $this->first_name ."Updated Equipment Name",
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					 return true;
			  }else{
				 return false;
			  }	
		}

	/*	CREATE  TABLE `admin_tolls`.`vehicletypes` (
  `id` INT NOT NULL AUTO_INCREMENT ,
  `VehicleType` VARCHAR(45) NOT NULL ,
  `DateCreated` DATETIME NOT NULL ,
  `DateModified` DATETIME NOT NULL ,
  `CreatedBy` INT NOT NULL ,
  `ModifiedBy` INT NOT NULL ,
  `Status` TINYINT NOT NULL DEFAULT 1 ,
  PRIMARY KEY (`id`) );*/

	 
}