<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Parents extends CI_Model {
		
		public function __construct(){
			
			$this->table="parents";
			$this->datetime=date("Y-m-d H:i:s");
		    $this->id=$this->session->userdata('id');
		   
		    $this->first_name=$this->session->userdata('first_name');
		    
		}

		public function creates()
		{
			
			$this->db->trans_begin();
			if($this->db->insert( $this->table, [
				
				'DateCreated' => $this->datetime,
				'FirstName' => $this->input->post("FirstName"),
				'LastName' => $this->input->post("LastName"),
				'OtherName' => $this->input->post("OtherName"),
				'Telephone' => '0'.substr($this->input->post("Telephone"),-9,9 ),
				'DateModified'=>$this->datetime,
				'CreatedBy'=>$this->id, 
				'ModifiedBy'=>$this->id,   			
				
				
			] )){
				  $id = $this->db->insert_id();
			
				  $this->db->insert('Audit', [

						'Description' => $this->first_name ." added parent ".  $this->input->post("FirstName") ." ". $this->input->post("LastName"),
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );

				    $this->db->where('id', $id);
					$data=array('parentID'=>$id);
			        $this->db->update($this->table, $data);

			       if ($this->db->trans_status() === FALSE)
	 				{
	       				 $this->db->trans_rollback();
	       				 $this->db->close();
	       				 return false;
					}
					else
					{
	      				  $this->db->trans_commit();
	      				  $this->db->close();
	      				     return true;
					}


				 
				
				}else{
					$this->db->close();
					return false;
				}

				
				
				
			
		}

		

		public function lists()
		{
			
			$rows = [];
			$this->db->select('u.*,s.titles as status,t.FirstName as NameCreatedBy' )
					->from($this->table .' u')
					 ->join('users t', 't.UserID=u.ModifiedBy') 
		            ->join('statuses s', 'u.status=s.status_id') 
					->order_by('u.id','desc');
			$query = $this->db->get();
			if($query->result()){
				$rows = $query->result();	
				$query->free_result();
				$this->db->close();	
			}
			

			return( $rows );	
				
		}

		public function details($id){
			 
			$row = array();		
			$this->db->select('*');
			$this->db->from( $this->table);	
			$this->db->where('id',$id);
			$query = $this->db->get();
			if($query->result()){
				$row = $query->row();	
				$query->free_result();
				$this->db->close();	
			}		
			return( $row );
		}
		public function edits($id)
		{
			
			
			 $data = array(
				
		
				'FirstName' => $this->input->post("FirstName"),
				'LastName' => $this->input->post("LastName"),
				'OtherName' => $this->input->post("OtherName"),
				'Telephone' => '0'.substr($this->input->post("Telephone"),-9,9 ),
				'Status' => $this->input->post("Status") ,
				'DateModified'=>$this->datetime,
				'ModifiedBy'=>$this->id,   	  
				);
			  $this->db->where('id',$id);
			  if($this->db->update($this->table,  $data)){
			  		$this->db->insert('Audit', [
			  			'Description' => $this->first_name ." edited parent ".  $this->input->post("FirstName") ." ". $this->input->post("LastName"),
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					$this->db->close();
					 return true;
			  }else{
				 return false;
			  }	
		}


		
	
		public function deletee($id)
		{
			
			 $data = array(
						'DateModified' => $this->datetime,
						'ModifiedBy'=>$this->id, 
						'status' => 0,	
				);

			  $this->db->where('Id',$id);
			  if($this->db->update($this->table,  $data)){
			  	
			  		$this->db->insert('Audit', [
			  			'Description' => $this->first_name ." Deleted parent ",
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					$this->db->close();
					return true;
			  }else{
				 return false;
			  }	
		}
		

	
		
		
		
		
}