<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Incometypes extends CI_Model {
		
		public function __construct(){
			
			$this->table="incometypes";
			$this->datetime=date("Y-m-d H:i:s");
		    $this->id=1;//$this->session->userdata('id');
		   
		    $this->first_name=$this->session->userdata('first_name');
		   
		   
		}

		public function creates()
		{

		
			
			$this->db->trans_begin();
			if($this->db->insert( $this->table, [
				'incomeTypeDescription' => $this->input->post("incomeTypeDescription"),
				'incomeTypePrefix' => $this->input->post("incomeTypePrefix"),
				'Description' => $this->input->post("Description"),
				'dateCreated' => $this->datetime,
				'dateModified' => $this->datetime,
                'createdBy' => $this->id,
                'modifiedBy' => $this->id,
                	
			] )){
				  $id = $this->db->insert_id();

				  $data = array(
				    'incomeTypeId' =>$id ,
				   
			     );

			     $this->db->where('id',$id);
			     $this->db->update($this->table,  $data);
                 

				  $this->db->insert('audit', [
						'Description' =>  $this->first_name ." added incometype -".  $this->input->post("incomeTypeDescription") ,
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
				] );

				       
			    if ($this->db->trans_status() === FALSE)
	 			{
	       				 $this->db->trans_rollback();
	       				 return false;
					}
					else
					{
	      				  $this->db->trans_commit();
	      				     return true;
				}
				}else{
					return false;
				}

				
				
				
			
		}

		
		public function lists()
		{
			$rows = [];
			$this->db->select('t.*,u.FirstName,s.Title as status' )
					->from($this->table .' t')
					
					->join('users u', 't.createdBy=u.UserID')
					->join('statuses s', 't.status=s.StatusId') 
					->order_by('t.id','DESC');
			//$this->db->where( array('t.Status'=>1),'AND');
			$query = $this->db->get();
			if($query->result()){
				$rows = $query->result();	
				$query->free_result();	
			}
			return( $rows );
		}


		
		public function details($id){
			$row = array();		
			$this->db->select('*');
			$this->db->from( $this->table);	
            $this->db->where('id',$id);
            $query = $this->db->get();
			if($query->result()){
				$row = $query->row();	
				$query->free_result();	
			}
			
			return( $row );
		}
		
		
		
		
		public function deletee($id)
		{
			$data = array(
				'dateModified' => $this->datetime,
				'status' => 0 ,	
				'modifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." deactivated  incometype ",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		public function activateds($id)
		{
			$data = array(
				'dateModified' => $this->datetime,
				'status' => 1 ,	
				'modifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." activated Incident Type ",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		
		public function edit($id)
		{
			 		
			 
			 $data = array(
			 	'incomeTypeDescription' => $this->input->post("incomeTypeDescription"),
				'incomeTypePrefix' => $this->input->post("incomeTypePrefix"),
				'Description' => $this->input->post("Description"),
				'dateModified' => $this->datetime,
                'modifiedBy' => $this->id,
				
			  );

			  $this->db->where('incomeTypeId',$id);
			  
			  if($this->db->update($this->table,  $data)){
			  		$this->db->insert('audit', [
			  			'Description' =>  $this->first_name ." updated incometype ",
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					 return true;
			  }else{
				 return false;
			  }	
		}

		


	 
}