<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	class Charges extends CI_Model {
		
		public function __construct(){
			
			$this->table="charges";
			$this->datetime=date("Y-m-d H:i:s");
		    $this->id=$this->session->userdata('id');
		   
		    $this->first_name=$this->session->userdata('first_name');
		   
		   
		}

		public function creates()
		{
			
			$this->db->trans_begin();
			if($this->db->insert( $this->table, [
				'VehicleTypeId' => $this->input->post("VehicleTypeId"),
				'Charge' => $this->input->post("Charge"),
				'DateCreated' => $this->datetime,
				'DateModified' => $this->datetime,
                'CreatedBy' => $this->id,
                'ModifiedBy' => $this->id,
                	
			] )){
				  $id = $this->db->insert_id();
                 

				  $this->db->insert('audit', [
						'Description' =>  $this->first_name ." added Charge-".  $this->input->post("Charge"),
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
				] );

				       
			    if ($this->db->trans_status() === FALSE)
	 			{
	       				 $this->db->trans_rollback();
	       				 return false;
					}
					else
					{
	      				  $this->db->trans_commit();
	      				     return true;
				}
				}else{
					return false;
				}

				
				
				
			
		}

		
		public function lists()
		{
			$rows = [];
			$this->db->select('t.*,v.VehicleType,u.FirstName,,s.Title as status' )
					->from($this->table .' t')
					->join('vehicletypes v', 'v.id=t.VehicleTypeId')
					->join('users u', 't.CreatedBy=u.UserId')
					 ->join('statuses s', 't.Status=s.StatusId') 
					->order_by('t.id','DESC');
			//$this->db->where( array('t.Status'=>1),'AND');
			$query = $this->db->get();
			if($query->result()){
				$rows = $query->result();	
				$query->free_result();	
			}
			return( $rows );
		}


		
		public function details($id){
			$row = array();		
			$this->db->select('*');
			$this->db->from( $this->table);	
            $this->db->where('id',$id);
            $query = $this->db->get();
			if($query->result()){
				$row = $query->row();	
				$query->free_result();	
			}
			
			return( $row );
		}
		public function vehicletypes(){
			$row = array();		
			$this->db->select('*');
			$this->db->from( "vehicletypes");	
            $this->db->where('Status',1);
            $query = $this->db->get();
			if($query->result()){
				$row = $query->result();	
				$query->free_result();	
			}
			
			return( $row );
		}
		public function checkcharges($VehicleTypeId){
			$row = array();		
			$this->db->select('*');
			$this->db->from( $this->table);	
            $this->db->where('VehicleTypeId',$VehicleTypeId);
            $query = $this->db->get();
			if($query->result()){
				$row = $query->row();	
				$query->free_result();	
			}
			
			return( $row );
		}

		
		
		
		public function deletee($id)
		{
			$data = array(
				'DateModified' => $this->datetime,
				'Status' => 0 ,	
				'ModifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." deactivated charge ",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		public function activateds($id)
		{
			$data = array(
				'DateModified' => $this->datetime,
				'Status' => 1 ,	
				'ModifiedBy' => $this->id,
			);

			$this->db->where('id',$id);
			if($this->db->update($this->table,  $data)){
				
					$this->db->insert('audit', [
						'Description' => $this->first_name ." activated charge ",
						'SourceTable' =>$this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					return true;
			}else{
				return false;
			}	
		}
		
		public function edits($id)
		{
			 		
			 
			 $data = array(
			 	
				'Charge' => $this->input->post("ChargeAmount"),
				'DateModified' => $this->datetime,
                'ModifiedBy' => $this->id,
				
			  );

			  $this->db->where('id',$id);
			  
			  if($this->db->update($this->table,  $data)){
			  		$this->db->insert('audit', [
			  			'Description' =>  $this->first_name ."Updated charge",
						'SourceTable' => $this->table,
						'RecordKey'=> $id,
						'UserKey'=>  $this->id
						
					] );
					 return true;
			  }else{
				 return false;
			  }	
		}

		

	/*	CREATE  TABLE `admin_tolls`.`charges` (
  `id` INT NOT NULL AUTO_INCREMENT ,
  `VehicleTypeId` INT NOT NULL ,
  `Charge` INT NOT NULL ,
  `DateCreated` DATETIME NOT NULL ,
  `DateModified` DATETIME NOT NULL ,
  `CreatedBy` INT NOT NULL ,
  `ModifiedBy` INT NOT NULL ,
  `Status` TINYINT NOT NULL DEFAULT 1 ,
  PRIMARY KEY (`id`) );*/

	 
}