<?php 
if( !defined('BASEPATH') ) exit('No direct script access allowed');

class Report extends CI_Controller 
{


	public function __construct()
	{
  		parent::__construct();
		
		if( $this->session->userdata('is_logged_in') !=1  ){
      
                   redirect('login');
             }

		    $this->load->model("reports");
		    $this->data['parent_page'] = 'Agent';
		    $this->id=$this->session->userdata('id');
		 	$this->datetime=date("Y-m-d H:i:s");
		
		
  	}

  	public function index()
	{
		$this->data['title'] = "elegance|| Jobs";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'All jobs';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->jobs($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/job' );		
		$this->load->view( "templates/footer" );
	}
	

	
	public function job()
	{
		$this->data['title'] = "ellegance|| All Jobs Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Total jobs';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->jobs($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/job' );		
		$this->load->view( "templates/footer" );
	}
	
	public function searchjobs()
	{
		$dateFrom = $this->input->post("DateFrom");
		$dateTo = $this->input->post("DateTo");
	
		// Check if the dates are properly received
		if ($dateFrom && $dateTo) {
			$results = $this->reports->jobs($dateFrom, $dateTo);
	
			if (empty($results)) {
				$message = 'No result between ' . $dateFrom . ' and ' . $dateTo;
				exit(json_encode(['status' => 'ERROR', 'success' => $message]));
			} else {
				$data = [
					"DateFrom" => $dateFrom,
					"DateTo" => $dateTo,
					"url" => "jobs",
					"responsedata" => $results
				];
				exit(json_encode(['status' => 'OK', 'success' => 'Successfully got result', 'responsedata' => $data]));
			}
		} else {
			exit(json_encode(['status' => 'ERROR', 'success' => 'Invalid dates']));
		}
	}

	public function delivered()
	{
		$this->data['title'] = "elegance || Delivered jobs Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Delivered jobs';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->delivereds($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/delivered' );		
		$this->load->view( "templates/footer" );
	}	
		
	public function done()
	{
		$this->data['title'] = "elegance || completed jobs Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'completed jobs';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->dones($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/done' );		
		$this->load->view( "templates/footer" );
	}	
	public function ongoing()
	{
		$this->data['title'] = "Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'On Going jobs';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->ongoings($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/ongoing' );		
		$this->load->view( "templates/footer" );
	}	

	public function artwork()
	{
		$this->data['title'] = "Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Awaiting Artwork';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->artworks($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/artwork' );		
		$this->load->view( "templates/footer" );
	}	
	public function awaitingD()
	{
		$this->data['title'] = "Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Awaiting Delivery';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->awaitingDs($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/awaitingD' );		
		$this->load->view( "templates/footer" );
	}	
	public function reccee()
	{
		$this->data['title'] = "Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Reccee';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->reccees($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/reccee' );		
		$this->load->view( "templates/footer" );
	}	
	public function invoice()
	{
		$this->data['title'] = "Report";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Invoiced Job';
		$this->data['DateFrom']=date('Y-m-01');
		$this->data['DateTo']=date('Y-m-d');
		$this->data['records']= $this->reports->invoices($this->data['DateFrom'],$this->data['DateTo']);
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'report/invoice' );		
		$this->load->view( "templates/footer" );
	}	

	
	
	
	


        	

	
	


	



















	

	


	
	

	

	


	

	



















	
	






}