<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Newjob extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('is_logged_in') != 1) {
            redirect('login');
        }
        
        $this->load->model("Newjobs");
    }
  
    public function index() {
        $this->data['title'] = "elegance || New Job ";
        $this->data['sub_title'] = "Dashboard";
        $this->data['page'] = 'New Job';
        $this->data['records'] = $this->Newjobs->lists();
        
        $this->load->view("templates/header", $this->data);
        $this->load->view('newjob/list');
        $this->load->view("templates/footer");
    }

    public function add() {
        if ($this->Newjobs->creates()) {
            $this->session->set_flashdata("success", "Job added successfully");
        } else {
            $this->session->set_flashdata('ERROR', 'Error occurred while adding a New job');
        }
        redirect('newjob');
    }
  
  public function deactivated()
  {
    $this->Newjobs->deletee($this->uri->segment(3));
    
    echo json_encode(array("status" => TRUE));
  }
  
  public function activated()
  {
    $this->fNewjobs->activateds($this->uri->segment(3));
    
    echo json_encode(array("status" => TRUE));
  }
 

      


  public function edit()
	{  $this->data['title'] = "elegance || Edit";
    $this->data['sub_title']="Dashboards";
    $this->data['page'] = 'Edit job';
	//  $this->data['fa']="fa fa-edit";
  $this->form_validation->set_rules( [

    ['field' => 'Date', 'label' => 'Date', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
  ['field' => 'ClientName', 'label' => 'ClientName', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
   
   ['field' => 'JobDescription', 'label' => 'JobDescription', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'Quantity', 'label' => 'Quantity', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    //['field' => 'LPONo', 'label' => 'LPONo', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'AccountM', 'label' => 'AccountM', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'OperationP', 'label' => 'OperationP', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'BriefNo', 'label' => 'BriefNo', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'InvoiceNo', 'label' => 'InvoiceNo', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
    ['field' => 'status', 'label' => 'status', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
 ] );
 
	  if( $this->form_validation->run() == FALSE ) :
		$this->data['record']= $this->Newjobs->details($this->uri->segment(3));
    $this->load->view( "templates/header", $this->data );
    $this->load->view( "newjob/edit" );   
    $this->load->view( "templates/footer" );
	  else :
	  
		if( $this->Newjobs->edits($this->uri->segment(3)) ) : 
		  $this->session->set_flashdata( "success","job info edited successfully" );
		  redirect( 'newjob' );
		else :
		  redirect( 'newjob/edit' );
		endif;
	  endif;  
	  
	}
  public function delete_job($id)
	{
	 $this->Newjobs->deletejob($id);
	 	 $this->session->set_flashdata( "success","The job  has been deleted successfully" );

     redirect(base_url('newjob'));	
	}

 
}