<?php 
if( !defined('BASEPATH') ) exit('No direct script access allowed');

class Farm extends CI_Controller 
{


	public function __construct()
	{
  		parent::__construct();
		
		 if( $this->session->userdata('is_logged_in') !=1  ){
      
                   redirect('login');
             }
    
   /*  if($this->session->userdata('password_set')==0){
       redirect('login/setpassword');
    }*/
		$this->load->model("services");
		$this->load->model("clients");
		$this->data['parent_page'] = 'Farms';
		$this->id=$this->session->userdata('id');
		$this->datetime=date("Y-m-d H:i:s");
		$this->datetime=date("Y-m-d H:i:s");
		
		
  	}

  	public function index()
	{

		$this->data['title'] = "FLID | Farm";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Farms';
		
		$this->data['records']= $this->services->listfarms();
		/*echo "<pre>";
		print_r($this->data['records']);
		exit;*/
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'farm/list' );		
		$this->load->view( "templates/footer" );
	}



	 public function add()
	{
		$this->form_validation->set_rules( [

		
			
			['field' => 'Subcounty', 'label' => 'Subcounty', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			
			['field' => 'County', 'label' => 'County', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'Ward', 'label' => 'Ward', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			
			
			
										
		] );
		
		if( $this->form_validation->run() == FALSE ) :
			$this->data['title'] = "RevenueSure | Toll Collections Transactions";
		    $this->data['sub_title']="Dashboards";
			$this->data['page'] = 'Add Farm';
			$this->data['FarmerId']= $this->uri->segment(3);
			$this->data['getcountys']= $this->services->getcountys();
			$this->data['irrigations']= $this->services->irrigationtypes();
			
			$this->load->view( "templates/header", $this->data );
			$this->load->view( 'farm/add' );		
			$this->load->view( "templates/footer" );
		else :

			

			$data=[
                  'FarmerId' =>$this->uri->segment(3),
                  'IrrigationType' =>$this->input->post("Irrigation"),
				  //'EntityId' =>$this->input->post("Entity"),
                  'CountyId'=>$this->input->post("County"),
                  'SubCountyId'=>$this->input->post("Subcounty"),
                  'WardId'=>$this->input->post("Ward"),
                  'Village'=>$this->input->post("Village"),
                  'FarmSize'=>$this->input->post("FarmSize"),
                  'IrrigatedFarmSize'=>$this->input->post("IrrigatedFarmSize"),
                  'Latitude'=>$this->input->post("Latitude"),
                  'Logitude'=>$this->input->post("Longitude"),
                  'CreatedBy'=>$this->id,
                  'ModifiedBy'=>$this->id,
                  'DateCreated' => $this->datetime,
                  'DateModified'=>$this->datetime,
                 ];
			if( $id=$this->services->addfarmss($data,$this->id) ) : 
				$this->session->set_flashdata( "success",'Farm added successfully' );
				redirect( 'farm/assign/'.$id .'/' . $this->uri->segment(3));
			else :
				$this->session->set_flashdata( "error", 'Error occurred while adding Farm ' );
				redirect( 'farm' );
			endif;
			
		endif;	
		
	} 



	public function edit()
	{	
		$this->data['title'] = "RevenueSure | Toll Collections Transactions";
		$this->data['sub_title']="Dashboards";
		$this->data['page'] = 'Edit Farm';
		$this->form_validation->set_rules( [

			['field' => 'FirstName', 'label' => 'First name', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'OtherName', 'label' => 'OtherName', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'RoleId', 'label' => 'Role ', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'IDNumber', 'label' => 'IDNumber', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'PhoneNumber', 'label' => 'Phone Number', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			['field' => 'EmailAddress', 'label' => 'EmailAddress', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
		
			
		] );
		if( $this->form_validation->run() == FALSE ) :
			$this->data['record']= $this->clients->detail_user($this->uri->segment(3));
			//$this->data['statuses']= $this->clients->statuses();
			$this->load->view( "templates/header", $this->data );
			$this->load->view( 'client/edit' );		
			$this->load->view( "templates/footer" );
		else :
		
			if( $this->clients->edit_users($this->uri->segment(3)) ) : 
				$this->session->set_flashdata( "success","Farm info edited successfully" );
				redirect( 'client' );
				
			else :
				
				redirect( 'client' );
			endif;
		endif;	
		
	}
	public function delete()
	 {

			if( $this->clients->deletee($this->uri->segment(3)) ) : 
				$this->session->set_flashdata( "success","Farm deleted successfully" );
				redirect( 'client' );
			else :
				$this->session->set_flashdata( "error", "Error occurs while deleting Farm" );
				redirect( 'client' );
			endif;
			
	
	 }

	 public function getsubcountys()
     {
   
       $getsubcounty= $this->services->getsubcountys($this->uri->segment(3));
          
          $options = array();
          $options[""]='Select Subcounty'; 
	    for( $i=0; $i<count($getsubcounty); $i++ ) :
	      $subcounty = &$getsubcounty[$i];
	      $options[$subcounty->ConstituencyCode] = $subcounty->ConstituencyName; 
	    endfor;   
	    echo json_encode( $options );
	     
       }
       public function getwards()
     {
   
       $wards= $this->services->getwards($this->uri->segment(3));
          
          $options = array();
          $options[""]='Select Ward'; 
	    for( $i=0; $i<count($wards); $i++ ) :
	      $ward = &$wards[$i];
	      $options[$ward->WardCode] = $ward->WardName; 
	    endfor;   
	    echo json_encode( $options );
	     
       }

     public function view()
	{

		$this->data['title'] = "FLID | Farm";
		$this->data['sub_title']="Farm";
		$this->data['page'] = 'Details';
		
		$this->data['farmerdatails']= $this->services->farmerdatails($this->uri->segment(4));
		$this->data['farmdatails']= $this->services->farmdatails($this->uri->segment(3),$this->uri->segment(4));
		$this->data['cropdetail']= $this->services->cropdetails($this->uri->segment(3),$this->uri->segment(4));
		//$this->data['otherdetails']= $this->services->cropdetails($this->uri->segment(3),$this->uri->segment(4));
		$this->data['getlogation']= $this->services->getlogations($this->uri->segment(3),$this->uri->segment(4));
		/* echo '<pre>';
		print_r($this->data['cropdetail']['Otherdetails']);
		exit; */
		//$this->data['otherdetail'] = explode(',',$this->data['cropdetail']['SellingYourProduceId']);
		//$emp_id = $this->session->userdata('user_login_id1');
		$mentity = $this->data['cropdetail']['Otherdetails'];	
		$perm_array = explode(',', $mentity->SellingYourProduceId);
		
			$this->data['otherdetail'] = $perm_array;
		/* foreach($perm_array as $perm):
			echo $perm[0];
			echo $perm[1];
			exit;
		endforeach; */
		/* echo '<pre>';
		print_r($perm_array);
		exit; */
		$this->load->view( "templates/header", $this->data );
		$this->load->view( 'farm/view' );		
		$this->load->view( "templates/footer" );
		
		/* echo '<pre>';
		print_r($perm_array);
		exit;  */
		
	}


	 public function assign()
	{
		$this->form_validation->set_rules( [

		
			
			['field' => 'FarmId', 'label' => 'FarmId', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			
			['field' => 'FarmerId', 'label' => 'FarmerId', 'rules' => 'trim|required', 'errors' => ['required' => 'Please enter the %s.'],],
			
			
			
			
										
		] );
		
		if( $this->form_validation->run() == FALSE ) :
			$this->data['title'] = "Farm | Assign Crops";
		    $this->data['sub_title']="Dashboards";
			$this->data['page'] = 'Assign Crop';
			$this->data['FarmerId']=$this->uri->segment(4);
			$this->data['FarmId']=$this->uri->segment(3);
			$this->data['getcrops']= $this->services->getcrops();
			$this->data['getmentity'] = $this->services->getmentity();
			$this->data['getequipments']= $this->services->getequipments();
			$this->load->view( "templates/header", $this->data );
			$this->load->view( 'farm/assign' );		
			$this->load->view( "templates/footer" );
		else :


			//insert size checkboxes into database.
			//$sizeArray = $this->input->post('MentityId');  // Array
       
			//$sizeString = implode(",", $sizeArray);    // String


			 $data=[
                  'FarmId' =>$this->input->post("FarmId"),
                  'FarmerId' =>$this->input->post("FarmerId"),
                  'Capacity'=>$this->input->post("Capacity"),
                  'WaterAdequate'=>$this->input->post("WaterAdequate"),
                  'AdequateNO'=>$this->input->post("AdequateNO"),
                  'EquipmentUsed'=>$this->input->post("EquipmentUsed"),
                  'ExtensionService'=>$this->input->post("ExtensionService"),
                  'ExtensionYes'=>$this->input->post("ExtensionYes"),
                  'ExtensionProvider' =>$this->input->post("ExtensionProvider"),
                  'MarketAvailable' =>$this->input->post("MarketAvailable"),
                  'ProduceComeFrom'=>$this->input->post("ProduceComeFrom"),
                  //'SellingYourProduceId'=>$this->input->post("MentityId"),
				  //'SellingYourProduceId'=>$sizeString,
				  'SellingYourProduceId' => implode(",",$this->input->post('MentityId')),
                  'MarketDistance'=>$this->input->post("MarketDistance"),
                  'ChallengesOnFarm'=>$this->input->post("ChallengesOnFarm"),
                  'ChallengesWithIrrigation'=>$this->input->post("ChallengesWithIrrigation"),
				  'AssistanceOnIrrigation' => $this->input->post('AssistanceOnIrrigation'),
                  'TypeOfAssistance'=>$this->input->post("TypeOfAssistance"),
                  'InvestInImproving'=>$this->input->post("InvestInImproving"),
                  'YesAmount'=>$this->input->post("YesAmount"),
                  'LoanToImprove'=>$this->input->post("LoanToImprove"),
                  'YesForWhat'=>$this->input->post("YesForWhat"),
                  'WhyNo'=>$this->input->post("WhyNo"),
                  'AnyTraining'=>$this->input->post("AnyTraining"),
                  'YesWhatArea'=>$this->input->post("YesWhatArea"),
                  'AnyComment'=>$this->input->post("AnyComment"),
                  'AdditionalInfomation'=>$this->input->post("AdditionalInfomation"),
                  'CreatedBy'=>$this->id,
                  'DateCreated' => $this->datetime,
                  'DateModified'=>$this->datetime,
                 ];
          if($record=$this->services->assigncrop1s($data,$this->id)):
		
				$this->session->set_flashdata( "success",'Assigned successfully' );
				redirect( 'tollTaker' );
			else :
				$this->session->set_flashdata( "error", 'Error occurred while adding Farm ' );
				redirect( 'farm/assign/'.$this->input->post("FarmId") .'/'.$this->input->post("FarmerId") );
			endif;
			
		endif;	
		
	} 


       
       
}

